<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class CleanupTempFilesCommand extends Command
{
    protected $signature = 'cleanup:temp {--days=7 : Delete files older than N days}';

    protected $description = 'Clean up temporary files and old logs';

    public function handle(): int
    {
        $days = (int) $this->option('days');
        $cutoff = now()->subDays($days)->getTimestamp();
        $count = 0;

        // Clean temp uploads
        $tempPath = storage_path('app/temp');
        if (is_dir($tempPath)) {
            foreach (new \DirectoryIterator($tempPath) as $file) {
                if ($file->isDot() || $file->isDir()) {
                    continue;
                }
                if ($file->getMTime() < $cutoff) {
                    unlink($file->getPathname());
                    $count++;
                }
            }
        }

        // Clean old log files (keep last 7 days)
        $logPath = storage_path('logs');
        foreach (new \DirectoryIterator($logPath) as $file) {
            if ($file->isDot() || $file->isDir()) {
                continue;
            }
            if ($file->getFilename() === 'laravel.log') {
                continue;
            }
            if ($file->getMTime() < $cutoff) {
                unlink($file->getPathname());
                $count++;
            }
        }

        $this->info("Cleaned up {$count} old files.");

        return Command::SUCCESS;
    }
}
