<?php

namespace App\Console\Commands;

use App\Models\Invoice;
use Illuminate\Console\Command;

class MarkOverdueInvoicesCommand extends Command
{
    protected $signature = 'invoices:mark-overdue';

    protected $description = 'Mark invoices past their due date as overdue';

    public function handle(): int
    {
        $count = Invoice::where('status', '!=', 'PAID')
            ->where('status', '!=', 'OVERDUE')
            ->where('status', '!=', 'CANCELLED')
            ->where('due_date', '<', now())
            ->update(['status' => 'OVERDUE']);

        $this->info("Marked {$count} invoices as overdue.");

        return Command::SUCCESS;
    }
}
