<?php

namespace App\Console\Commands;

use App\Models\ServiceBooking;
use App\Notifications\BookingConfirmedNotification;
use Illuminate\Console\Command;

class SendBookingRemindersCommand extends Command
{
    protected $signature = 'bookings:send-reminders';

    protected $description = 'Send reminders for bookings happening tomorrow';

    public function handle(): int
    {
        $tomorrow = now()->addDay()->startOfDay();
        $dayAfter = now()->addDay()->endOfDay();

        $bookings = ServiceBooking::with('customer')
            ->where('status', 'CONFIRMED')
            ->where('reminder_sent', false)
            ->whereBetween('date', [$tomorrow, $dayAfter])
            ->get();

        $count = 0;
        foreach ($bookings as $booking) {
            if ($booking->customer) {
                $booking->customer->notify(new BookingConfirmedNotification($booking));
                $booking->update(['reminder_sent' => true]);
                $count++;
            }
        }

        $this->info("Sent {$count} booking reminders.");

        return Command::SUCCESS;
    }
}
