<?php

namespace App\Enums;

enum UserRole: string
{
    case SuperAdmin = 'SUPER_ADMIN';
    case Admin = 'ADMIN';
    case BranchManager = 'BRANCH_MANAGER';
    case HRManager = 'HR_MANAGER';
    case FinancialAccountant = 'FINANCIAL_ACCOUNTANT';
    case SalesManager = 'SALES_MANAGER';
    case ContentEditor = 'CONTENT_EDITOR';
    case Employee = 'EMPLOYEE';
    case Customer = 'CUSTOMER';

    /**
     * Roles that can access the admin panel.
     */
    public static function adminRoles(): array
    {
        return [
            self::SuperAdmin,
            self::Admin,
            self::BranchManager,
            self::HRManager,
            self::FinancialAccountant,
            self::SalesManager,
            self::ContentEditor,
        ];
    }

    /**
     * Roles that can access the employee portal.
     */
    public static function employeeRoles(): array
    {
        return [
            self::SuperAdmin,
            self::Admin,
            self::BranchManager,
            self::HRManager,
            self::FinancialAccountant,
            self::SalesManager,
            self::ContentEditor,
            self::Employee,
        ];
    }

    /**
     * Check if this role can access the admin panel.
     */
    public function canAccessAdmin(): bool
    {
        return in_array($this, self::adminRoles());
    }

    /**
     * Check if this role can access the employee portal.
     */
    public function canAccessEmployee(): bool
    {
        return in_array($this, self::employeeRoles());
    }

    /**
     * Get all role values as strings.
     */
    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }
}
