<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CompanyInfo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class CompanyInfoController extends Controller
{
    public function edit()
    {
        $info = CompanyInfo::firstOrCreate(
            ['id' => 1], // Assuming single record with ID 1 or checks
            ['title' => 'Default Title']
        );
        // If seeded with 'firstOrCreate' in seeder without ID, fetch first
        $info = CompanyInfo::first();

        return view('admin.cms.company-info.edit', compact('info'));
    }

    public function update(Request $request)
    {
        $info = CompanyInfo::first();

        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'subtitle' => 'nullable|string|max:255',
            'description' => 'nullable|string',
            'image_url' => 'nullable|image|max:2048', // Allow upload
            'features' => 'nullable|array',
            'features.*' => 'string|max:255',
            'cta_text_1' => 'nullable|string',
            'cta_link_1' => 'nullable|string',
            'cta_text_2' => 'nullable|string',
            'cta_link_2' => 'nullable|string',
        ]);

        if ($request->hasFile('image_url')) {
            $path = $request->file('image_url')->store('company', 'public');
            $info->image_url = '/storage/'.$path;
        }

        $info->title = $validated['title'];
        $info->subtitle = $validated['subtitle'];
        $info->description = $validated['description'];

        // Filter out empty features
        $info->features = array_values(array_filter($validated['features'] ?? [], fn ($f) => ! empty($f)));

        // Reconstruct CTA buttons
        $buttons = [];
        if (! empty($validated['cta_text_1'])) {
            $buttons[] = [
                'text' => $validated['cta_text_1'],
                'link' => $validated['cta_link_1'] ?? '#',
                'variant' => 'primary',
            ];
        }
        if (! empty($validated['cta_text_2'])) {
            $buttons[] = [
                'text' => $validated['cta_text_2'],
                'link' => $validated['cta_link_2'] ?? '#',
                'variant' => 'secondary',
            ];
        }
        $info->cta_buttons = $buttons;

        $info->save();
        Cache::forget('footer_data');

        return redirect()->route('admin.cms.company-info.edit')->with('success', 'Company Info updated successfully.');
    }
}
