<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

class DashboardController extends Controller
{
    public function index()
    {
        $stats = [
            'total_users' => \App\Models\User::count(),
            'total_bookings' => \App\Models\ServiceBooking::count() + \App\Models\TestDriveBooking::count(),
            'total_vehicles' => \App\Models\Vehicle::count(),
            'revenue' => \App\Models\Invoice::where('payment_status', 'PAID')->sum('total_amount'),
        ];

        // Recent Service Bookings (simplifying to just service bookings for now, or could union)
        $recentBookings = \App\Models\ServiceBooking::with(['customer', 'vehicle'])
            ->latest()
            ->take(5)
            ->get();

        $recentVehicles = \App\Models\Vehicle::latest()
            ->take(5)
            ->get();

        return view('admin.dashboard', compact('stats', 'recentBookings', 'recentVehicles'));
    }
}
