<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Lead;
use App\Models\LeadActivity;
use Illuminate\Http\Request;

class LeadActivityController extends Controller
{
    public function store(Request $request, Lead $lead)
    {
        $validated = $request->validate([
            'type' => 'required|in:CALL,EMAIL,MEETING,NOTE,TEST_DRIVE,QUOTE',
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
            'performed_at' => 'nullable|date',
        ]);

        $activity = $lead->activities()->create([
            'type' => $validated['type'],
            'title' => $validated['title'],
            'description' => $validated['description'],
            'performed_by' => auth()->id(),
            'metadata' => ['performed_at' => $validated['performed_at'] ?? now()],
        ]);

        return back()->with('success', 'Activity logged successfully.');
    }
}
