<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\FinancialExportService;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function __construct(
        private FinancialExportService $exportService
    ) {}

    public function index()
    {
        return view('admin.reports.index');
    }

    public function exportProfitLoss(Request $request)
    {
        $request->validate([
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
        ]);

        return $this->exportService->exportProfitLoss($request->start_date, $request->end_date);
    }

    public function exportInventoryValuation()
    {
        return $this->exportService->exportInventoryValuation();
    }
}
