<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ServiceType;
use Illuminate\Http\Request;

class ServiceTypeController extends Controller
{
    public function index()
    {
        $types = ServiceType::all();

        return view('admin.service-types.index', compact('types'));
    }

    public function create()
    {
        return view('admin.service-types.create');
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'duration' => 'nullable|integer',
            'price' => 'nullable|numeric',
            'category' => 'nullable|string',
            'is_active' => 'boolean',
        ]);

        ServiceType::create($validated);

        return redirect()->route('admin.service-types.index')->with('success', 'Service Type created.');
    }

    public function edit(ServiceType $serviceType)
    {
        return view('admin.service-types.edit', compact('serviceType'));
    }

    public function update(Request $request, ServiceType $serviceType)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'duration' => 'nullable|integer',
            'price' => 'nullable|numeric',
            'category' => 'nullable|string',
            'is_active' => 'boolean',
        ]);

        $serviceType->update($validated);

        return redirect()->route('admin.service-types.index')->with('success', 'Service Type updated.');
    }

    public function destroy(ServiceType $serviceType)
    {
        $serviceType->delete();

        return redirect()->route('admin.service-types.index')->with('success', 'Service Type deleted.');
    }
}
