<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Vehicle;
use App\Models\Invoice;
use App\Models\ServiceBooking;
use App\Models\ServiceType;

class ApiController extends Controller
{
    public function user(Request $request) {
        return $request->user();
    }

    public function vehicles() {
        return Vehicle::where('status', 'AVAILABLE')
            ->with('images')
            ->paginate(20);
    }

    public function vehicleDetails(Vehicle $vehicle) {
        return $vehicle->load(['images', 'specifications', 'pricing']);
    }

    public function invoices(Request $request) {
        return Invoice::where('customer_id', $request->user()->id)
            ->latest()
            ->paginate(15);
    }

    public function bookings(Request $request) {
        return ServiceBooking::where('customer_id', $request->user()->id)
            ->latest()
            ->paginate(15);
    }

    public function availableVehicles() {
        return Vehicle::where('status', 'AVAILABLE')
            ->select('id', 'make', 'model', 'year', 'price', 'category', 'fuel_type')
            ->paginate(20);
    }

    public function serviceTypes() {
        return ServiceType::where('is_active', true)
            ->select('id', 'name', 'description', 'duration', 'price', 'category')
            ->get();
    }
}
