<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BookingController extends Controller
{
    public function index()
    {
        $bookings = Auth::user()->serviceBookings()
            ->with('vehicle', 'serviceType')
            ->latest('date')
            ->paginate(15);

        return view('customer.bookings.index', compact('bookings'));
    }

    public function show($id)
    {
        $booking = Auth::user()->serviceBookings()
            ->with('vehicle', 'serviceType')
            ->findOrFail($id);

        return view('customer.bookings.show', compact('booking'));
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'vehicle_id' => 'nullable|exists:vehicles,id',
            'service_type_id' => 'required|exists:service_types,id',
            'date' => 'required|date|after:today',
            'time' => 'required',
            'notes' => 'nullable|string|max:500',
        ]);
        Auth::user()->serviceBookings()->create(array_merge($validated, ['status' => 'PENDING']));

        return back()->with('success', 'تم إنشاء الحجز بنجاح. سنتواصل معك قريباً.');
    }
}
