<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $bookings = $user->serviceBookings()->with('vehicle', 'serviceType')->latest()->take(10)->get();
        // Extract unique vehicles from bookings
        $vehicles = $bookings->pluck('vehicle')->unique('id')->filter();

        $invoices = $user->invoices()->latest()->take(5)->get();
        $tickets = $user->tickets()->latest()->take(5)->get();

        return view('customer.dashboard.index', compact('user', 'bookings', 'vehicles', 'invoices', 'tickets'));
    }
}
