<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class InsuranceController extends Controller
{
    public function index()
    {
        $policies = \App\Models\InsurancePolicy::where('customer_id', Auth::id())
            ->with('company', 'vehicle')
            ->latest()
            ->paginate(15);
        $claims = \App\Models\InsuranceClaim::whereHas('policy', fn ($q) => $q->where('customer_id', Auth::id()))
            ->with('policy')
            ->latest()
            ->take(10)
            ->get();

        return view('customer.insurance.index', compact('policies', 'claims'));
    }
}
