<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class OrderController extends Controller
{
    public function index()
    {
        $orders = \App\Models\Order::where('customer_id', Auth::id())
            ->with('items')
            ->latest()
            ->paginate(15);

        return view('customer.orders.index', compact('orders'));
    }

    public function show($id)
    {
        $order = \App\Models\Order::where('customer_id', Auth::id())
            ->with('items', 'payments')
            ->findOrFail($id);

        return view('customer.orders.show', compact('order'));
    }
}
