<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class WarrantyController extends Controller
{
    public function index()
    {
        $warranties = \App\Models\Warranty::query()
            ->whereHas('contract', fn ($q) => $q->where('customer_id', Auth::id()))
            ->with(['vehicle', 'contract'])
            ->latest()
            ->paginate(15);

        $claims = \App\Models\WarrantyClaim::query()
            ->whereHas('warranty.contract', fn ($q) => $q->where('customer_id', Auth::id()))
            ->with(['warranty', 'vehicle'])
            ->latest()
            ->take(10)
            ->get();

        return view('customer.warranties.index', compact('warranties', 'claims'));
    }

    public function claimStore(Request $request)
    {
        $validated = $request->validate([
            'warranty_id' => 'required|exists:warranties,id',
            'description' => 'required|string|max:2000',
            'issue_type' => 'required|string|max:100',
        ]);

        $warranty = \App\Models\Warranty::query()
            ->with('contract')
            ->whereHas('contract', fn ($q) => $q->where('customer_id', Auth::id()))
            ->findOrFail($validated['warranty_id']);

        \App\Models\WarrantyClaim::create([
            'claim_number' => 'WCL-'.now()->format('Ymd').'-'.strtoupper(\Illuminate\Support\Str::random(6)),
            'warranty_id' => $warranty->id,
            'vehicle_id' => $warranty->vehicle_id,
            'customer_id' => $warranty->contract->customer_id,
            'description' => '['.$validated['issue_type'].'] '.$validated['description'],
            'claim_date' => now(),
            'status' => 'PENDING',
            'created_by' => Auth::id(),
        ]);

        return back()->with('success', 'تم تقديم مطالبة الضمان بنجاح.');
    }
}
