<?php

namespace App\Http\Controllers\Public;

use App\Http\Controllers\Controller;

class MaintenanceController extends Controller
{
    public function index()
    {
        // 1. SERVICES DATA
        $services = [
            (object) [
                'id' => '1',
                'name' => 'صيانة دورية',
                'description' => 'فحص شامل وصيانة منتظمة لضمان أداء سيارتك المثالي',
                'duration' => '2-3 ساعات',
                'price' => 'من 500 ج.م',
                'category' => 'صيانة',
                'features' => ['تغيير الزيت', 'فحص الفرامل', 'فحص الإطارات', 'فحص البطارية'],
                'icon' => 'Wrench',
                'popular' => true,
            ],
            (object) [
                'id' => '2',
                'name' => 'إصلاح محركات',
                'description' => 'خدمات متخصصة لإصلاح وصيانة محركات السيارات',
                'duration' => 'حسب الحالة',
                'price' => 'يبدأ من 1500 ج.م',
                'category' => 'إصلاحات',
                'features' => ['تشخيص أعطال المحرك', 'إصلاح كامل', 'صيانة وقائية', 'تحسين الأداء'],
                'icon' => 'Car',
                'popular' => false,
            ],
            (object) [
                'id' => '3',
                'name' => 'خدمة كاملة',
                'description' => 'خدمة شاملة تشمل جميع جوانب صيانة سيارتك',
                'duration' => '4-5 ساعات',
                'price' => 'من 1200 ج.م',
                'category' => 'خدمات',
                'features' => ['فحص 50 نقطة', 'تنظيف داخل وخارج', 'تغيير فلتر', 'ضبط المحرك'],
                'icon' => 'Shield',
                'popular' => true,
            ],
            (object) [
                'id' => '4',
                'name' => 'فحص كهرباء',
                'description' => 'تشخيص وإصلاح جميع المشاكل الكهربائية في السيارة',
                'duration' => '1-2 ساعة',
                'price' => 'من 300 ج.م',
                'category' => 'كهرباء',
                'features' => ['تشخيص كمبيوتر', 'إصلاح أسلاك', 'صيانة بطارية', 'فحص إضاءة'],
                'icon' => 'Zap',
                'popular' => false,
            ],
            // Add more defaults matching Next.js if needed
        ];

        $groupedServices = collect($services)->groupBy('category');

        // 2. PACKAGES DATA
        $packages = [
            (object) [
                'id' => '1',
                'name' => 'الباقة الأساسية',
                'description' => 'مثالية للصيانة الدورية والسيارات الجديدة',
                'price' => '999 جنيه',
                'savings' => 'توفير 10%',
                'services' => ['تغيير زيت وفلتر', 'فحص 20 نقطة', 'غسيل خارجي'],
                'includes' => ['تقرير حالة', 'خصم على قطع الغيار'],
                'validity' => '6 أشهر',
            ],
            (object) [
                'id' => '2',
                'name' => 'الباقة الشاملة',
                'description' => 'تغطية كاملة لراحة بالك على الطريق',
                'price' => '2499 جنيه',
                'savings' => 'توفير 20%',
                'services' => ['صيانتين دوريتين', 'فحص شامل', 'ترصيص إطارات', 'تغيير فلاتر'],
                'includes' => ['سيارة بديلة', 'خدمة طوارئ', 'تلميع داخلي'],
                'validity' => 'سنة واحدة',
            ],
            (object) [
                'id' => '3',
                'name' => 'باقة الأعمال',
                'description' => 'مخصصة للشركات وأساطيل النقل',
                'price' => 'مخصص',
                'savings' => 'توفير يصل لـ 30%',
                'services' => ['صيانة دورية مجدولة', 'تقارير أسطول', 'دعم فني مخصص'],
                'includes' => ['مدير حساب', 'فواتير شهرية', 'أولوية في الحجز'],
                'validity' => 'سنوي',
            ],
        ];

        // 3. TECHNICIANS DATA
        $technicians = [
            (object) [
                'id' => '1',
                'name' => 'أحمد محمد',
                'specialty' => 'ميكانيكا عامة',
                'experience' => '10 سنوات',
                'rating' => 4.8,
                'certifications' => ['معتمد من تاتا', 'شهادة ASE'],
                'image' => null, // Placeholder in view
            ],
            (object) [
                'id' => '2',
                'name' => 'محمود علي',
                'specialty' => 'كهرباء وتشخيص',
                'experience' => '7 سنوات',
                'rating' => 4.9,
                'certifications' => ['شهادة تشخيص أعطال', 'هندسة إلكترونيات'],
                'image' => null,
            ],
        ];

        return view('public.maintenance.index', compact('services', 'groupedServices', 'packages', 'technicians'));
    }
}
