<?php

namespace App\Http\Controllers\Public;

use App\Http\Controllers\Controller;

class ServicesController extends Controller
{
    public function index()
    {
        // Replicating Next.js defaultServices data for visual parity
        $services = [
            (object) [
                'id' => '1',
                'title' => 'صيانة دورية',
                'description' => 'فحص شامل وصيانة منتظمة لضمان أداء سيارتك المثالي',
                'icon' => 'Wrench',
                'features' => ['تغيير الزيت', 'فحص الفرامل', 'فحص الإطارات', 'فحص البطارية'],
                'price' => 'من 500 ج.م',
                'duration' => '2-3 ساعات',
                'category' => 'صيانة',
            ],
            (object) [
                'id' => '2',
                'title' => 'إصلاح محركات',
                'description' => 'خدمات متخصصة لإصلاح وصيانة محركات السيارات',
                'icon' => 'Car',
                'features' => ['تشخيص أعطال المحرك', 'إصلاح كامل', 'صيانة وقائية', 'تحسين الأداء'],
                'price' => 'يبدأ من 1500 ج.م',
                'duration' => 'حسب الحالة',
                'category' => 'إصلاحات',
            ],
            (object) [
                'id' => '3',
                'title' => 'خدمة كاملة',
                'description' => 'خدمة شاملة تشمل جميع جوانب صيانة سيارتك',
                'icon' => 'Shield',
                'features' => ['فحص 50 نقطة', 'تنظيف داخل وخارج', 'تغيير فلتر', 'ضبط المحرك'],
                'price' => 'من 1200 ج.م',
                'duration' => '4-5 ساعات',
                'category' => 'خدمات',
            ],
            (object) [
                'id' => '4',
                'title' => 'فحص كهرباء',
                'description' => 'تشخيص وإصلاح جميع المشاكل الكهربائية في السيارة',
                'icon' => 'Zap',
                'features' => ['تشخيص كمبيوتر', 'إصلاح أسلاك', 'صيانة بطارية', 'فحص إضاءة'],
                'price' => 'من 300 ج.م',
                'duration' => '1-2 ساعة',
                'category' => 'كهرباء',
            ],
        ];

        $serviceCopy = (object) [
            'title' => 'خدماتنا',
            'subtitle' => 'نقدم مجموعة شاملة من خدمات الصيانة والإصلاح لضمان أداء سيارتك المثالي',
            'description' => '',
            'ctaText' => 'احجز الآن',
        ];

        return view('public.services.index', compact('services', 'serviceCopy'));
    }
}
