<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Cache;

class SitemapController extends Controller
{
    public function index()
    {
        $content = Cache::remember('public_sitemap_xml', now()->addMinutes(30), function () {
            $urls = [
                route('home'),
                route('about'),
                route('contact'),
                route('parts'),
                route('warranty'),
                route('faq'),
                route('public.support'),
                route('terms'),
                route('privacy'),
                route('tata-motors'),
                route('vehicles.index'),
                route('public.service-booking'),
                route('public.test-drive'),
            ];

            $vehicles = \App\Models\Vehicle::select('id')->get();
            foreach ($vehicles as $vehicle) {
                $urls[] = route('vehicles.show', $vehicle->id);
            }

            return view('sitemap', compact('urls'))->render();
        });

        return response($content)->header('Content-Type', 'text/xml');
    }
}
