<?php

namespace App\Http\Middleware;

use App\Enums\UserRole;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (! auth()->check()) {
            return redirect('login');
        }

        $user = auth()->user();
        $allowedRoleValues = array_map(fn ($r) => $r->value, UserRole::adminRoles());

        if (! in_array($user->role, $allowedRoleValues, true)) {
            abort(403, 'Unauthorized access.');
        }

        return $next($request);
    }
}
