<?php

namespace App\Http\Middleware;

use App\Enums\UserRole;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EmployeeMiddleware
{
    /**
     * Ensure the authenticated user has an employee-level role.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (! auth()->check()) {
            return redirect('login');
        }

        $allowedRoleValues = array_map(fn ($r) => $r->value, UserRole::employeeRoles());

        if (! in_array(auth()->user()->role, $allowedRoleValues, true)) {
            abort(403, 'Unauthorized — employee access required.');
        }

        return $next($request);
    }
}
