<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreCampaignRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user() && in_array($this->user()->role, ['SUPER_ADMIN', 'ADMIN', 'CONTENT_EDITOR']);
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'type' => 'required|in:EMAIL,SMS,SOCIAL,WHATSAPP',
            'status' => 'nullable|in:DRAFT,ACTIVE,PAUSED,COMPLETED',
            'start_date' => 'nullable|date',
            'end_date' => 'nullable|date|after:start_date',
            'budget' => 'nullable|numeric|min:0',
            'target_audience' => 'nullable|string|max:1000',
            'content' => 'nullable|string|max:5000',
        ];
    }
}
