<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreContractRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user() && in_array($this->user()->role, ['SUPER_ADMIN', 'ADMIN', 'SALES_MANAGER', 'OPERATIONS_MANAGER']);
    }

    public function rules(): array
    {
        return [
            'type' => 'required|in:SALE,SERVICE,LEASE,WARRANTY',
            'customer_id' => 'required|exists:users,id',
            'vehicle_id' => 'nullable|exists:vehicles,id',
            'start_date' => 'required|date',
            'end_date' => 'nullable|date|after:start_date',
            'value' => 'required|numeric|min:0',
            'terms' => 'nullable|array',
            'attachments' => 'nullable|array',
            'attachments.*' => 'file|mimes:pdf,doc,docx,jpg,png|max:10240',
        ];
    }
}
