<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreEmployeeRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user() && in_array($this->user()->role, ['SUPER_ADMIN', 'ADMIN', 'HR_MANAGER']);
    }

    public function rules(): array
    {
        return [
            'user_id' => 'required|exists:users,id',
            'department' => 'required|string|max:100',
            'position' => 'required|string|max:100',
            'salary' => 'required|numeric|min:0',
            'hire_date' => 'required|date',
            'employment_type' => 'required|in:FULL_TIME,PART_TIME,CONTRACT,INTERN',
        ];
    }
}
