<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreExpenseRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user() && in_array($this->user()->role, ['SUPER_ADMIN', 'ADMIN', 'FINANCIAL_ACCOUNTANT']);
    }

    public function rules(): array
    {
        return [
            'category' => 'required|string|max:100',
            'amount' => 'required|numeric|min:0.01',
            'description' => 'required|string|max:1000',
            'date' => 'required|date',
            'payment_method' => 'nullable|in:CASH,BANK_TRANSFER,CHECK,CREDIT_CARD',
            'reference' => 'nullable|string|max:255',
            'receipt' => 'nullable|file|mimes:jpg,jpeg,png,pdf|max:5120',
            'account_id' => 'nullable|exists:accounts,id',
        ];
    }
}
