<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreJournalEntryRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user() && in_array($this->user()->role, ['SUPER_ADMIN', 'ADMIN', 'FINANCIAL_ACCOUNTANT']);
    }

    public function rules(): array
    {
        return [
            'date' => 'required|date',
            'reference' => 'nullable|string|max:255',
            'description' => 'required|string|max:1000',
            'entries' => 'required|array|min:2',
            'entries.*.account_id' => 'required|exists:accounts,id',
            'entries.*.type' => 'required|in:debit,credit',
            'entries.*.amount' => 'required|numeric|min:0.01',
            'entries.*.description' => 'nullable|string|max:500',
        ];
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            $entries = $this->input('entries', []);
            $debits = collect($entries)->where('type', 'debit')->sum('amount');
            $credits = collect($entries)->where('type', 'credit')->sum('amount');
            if (abs($debits - $credits) > 0.01) {
                $validator->errors()->add('entries', 'إجمالي المدين يجب أن يساوي إجمالي الدائن');
            }
        });
    }
}
