<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreOpportunityRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user() && in_array($this->user()->role, ['SUPER_ADMIN', 'ADMIN', 'SALES_MANAGER', 'SALES_AGENT']);
    }

    public function rules(): array
    {
        return [
            'lead_id' => 'required|exists:leads,id',
            'title' => 'required|string|max:255',
            'value' => 'required|numeric|min:0',
            'stage' => 'required|in:PROSPECTING,QUALIFICATION,PROPOSAL,NEGOTIATION,CLOSED_WON,CLOSED_LOST',
            'probability' => 'nullable|integer|min:0|max:100',
            'expected_close_date' => 'nullable|date|after:today',
            'notes' => 'nullable|string|max:2000',
        ];
    }
}
