<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StorePaymentRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user() && in_array($this->user()->role, ['SUPER_ADMIN', 'ADMIN', 'FINANCIAL_ACCOUNTANT']);
    }

    public function rules(): array
    {
        return [
            'invoice_id' => 'required|exists:invoices,id',
            'amount' => 'required|numeric|min:0.01',
            'payment_method' => 'required|in:CASH,BANK_TRANSFER,CREDIT_CARD,CHECK,MOBILE_PAYMENT',
            'payment_date' => 'required|date',
            'reference_number' => 'nullable|string|max:100',
            'transaction_id' => 'nullable|string|max:100',
            'notes' => 'nullable|string|max:1000',
        ];
    }
}
