<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreVehicleRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user() && in_array($this->user()->role, ['SUPER_ADMIN', 'ADMIN', 'BRANCH_MANAGER', 'SALES_MANAGER']);
    }

    public function rules(): array
    {
        return [
            'make' => 'required|string|max:100',
            'model' => 'required|string|max:100',
            'year' => 'required|integer|min:1900|max:'.(date('Y') + 2),
            'color' => 'nullable|string|max:50',
            'vin' => 'nullable|string|max:17|unique:vehicles,vin',
            'price' => 'required|numeric|min:0',
            'mileage' => 'nullable|integer|min:0',
            'fuel_type' => 'nullable|string|in:GASOLINE,DIESEL,ELECTRIC,HYBRID,LPG',
            'transmission' => 'nullable|string|in:AUTOMATIC,MANUAL,CVT',
            'body_type' => 'nullable|string|max:50',
            'status' => 'nullable|in:AVAILABLE,SOLD,RESERVED,MAINTENANCE',
            'branch_id' => 'nullable|exists:branches,id',
            'description' => 'nullable|string|max:2000',
            'features' => 'nullable|array',
            'features.*' => 'string|max:255',
            'specifications' => 'nullable|array',
            'images' => 'nullable|array',
            'images.*' => 'image|mimes:jpg,jpeg,png,webp|max:5120',
        ];
    }
}
