<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class AttendanceRecord extends Model
{
    use HasUuids;

    protected $fillable = ['employee_id', 'date', 'check_in', 'check_out', 'status', 'notes'];

    protected $casts = ['date' => 'date', 'check_in' => 'datetime', 'check_out' => 'datetime'];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
