<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class CalendarEvent extends Model
{
    use HasUuids;

    protected $fillable = ['title', 'description', 'type', 'start_time', 'end_time', 'all_day', 'location', 'status', 'color', 'created_by', 'assigned_to', 'branch_id', 'metadata'];

    protected $casts = ['start_time' => 'datetime', 'end_time' => 'datetime', 'all_day' => 'boolean', 'metadata' => 'array'];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function assignee()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }
}
