<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Campaign extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'name', 'description', 'type', 'status', 'target_audience',
        'budget', 'start_date', 'end_date', 'created_by',
    ];

    protected $casts = [
        'target_audience' => 'array',
        'budget' => 'decimal:2',
        'start_date' => 'datetime',
        'end_date' => 'datetime',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function leads()
    {
        return $this->hasMany(Lead::class);
    }
}
