<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class CampaignMember extends Model
{
    use HasUuids;

    protected $fillable = ['campaign_id', 'customer_id', 'lead_id', 'status', 'metadata'];

    protected $casts = ['metadata' => 'array'];

    public function campaign()
    {
        return $this->belongsTo(MarketingCampaign::class, 'campaign_id');
    }

    public function customer()
    {
        return $this->belongsTo(CustomerProfile::class);
    }

    public function lead()
    {
        return $this->belongsTo(Lead::class);
    }
}
