<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Complaint extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'complaint_number', 'customer_id', 'subject', 'description',
        'category', 'severity', 'status', 'assigned_to',
        'resolution', 'branch_id',
    ];

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function assignedTo()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function followUps()
    {
        return $this->hasMany(ComplaintFollowUp::class);
    }
}
