<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ComplaintFollowUp extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'complaint_id', 'author_id', 'content', 'action', 'next_follow_up',
    ];

    protected $casts = [
        'next_follow_up' => 'datetime',
    ];

    public function complaint()
    {
        return $this->belongsTo(Complaint::class);
    }

    public function author()
    {
        return $this->belongsTo(User::class, 'author_id');
    }
}
