<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContactInfo extends Model
{
    use HasFactory, HasUuids;

    protected $table = 'contact_info';

    protected $fillable = [
        'phone',
        'email',
        'address',
        'map_url',
        'working_hours',
        'social_links',
    ];

    protected $casts = [
        'working_hours' => 'array',
        'social_links' => 'array',
    ];
}
