<?php

namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contract extends Model
{
    use HasUuids, LogsActivity, SoftDeletes;

    protected $fillable = ['contract_number', 'type', 'customer_id', 'vehicle_id', 'start_date', 'end_date', 'value', 'status', 'terms', 'attachments', 'created_by', 'approved_by', 'approved_at', 'branch_id'];

    protected $casts = ['start_date' => 'datetime', 'end_date' => 'datetime', 'approved_at' => 'datetime', 'terms' => 'array', 'attachments' => 'array'];

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function warranties()
    {
        return $this->hasMany(Warranty::class);
    }
}
