<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class CrmInteraction extends Model
{
    use HasUuids;

    protected $fillable = ['lead_id', 'opportunity_id', 'type', 'title', 'description', 'performed_by', 'interaction_date', 'outcome', 'metadata'];

    protected $casts = ['interaction_date' => 'datetime', 'metadata' => 'array'];

    public function lead()
    {
        return $this->belongsTo(Lead::class);
    }

    public function opportunity()
    {
        return $this->belongsTo(Opportunity::class);
    }

    public function performer()
    {
        return $this->belongsTo(User::class, 'performed_by');
    }
}
