<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class CustomerFeedback extends Model
{
    use HasUuids;

    protected $table = 'customer_feedbacks';

    protected $fillable = ['customer_id', 'type', 'rating', 'comment', 'status', 'response', 'responded_by', 'responded_at'];

    protected $casts = ['responded_at' => 'datetime'];

    public function customer()
    {
        return $this->belongsTo(CustomerProfile::class, 'customer_id');
    }

    public function responder()
    {
        return $this->belongsTo(User::class, 'responded_by');
    }
}
