<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class CustomerInteraction extends Model
{
    use HasUuids;

    protected $fillable = [
        'customer_id', 'type', 'title', 'description', 'performed_by',
        'interaction_date', 'outcome', 'notes', 'metadata',
    ];

    protected $casts = ['interaction_date' => 'datetime', 'metadata' => 'array'];

    public function customer()
    {
        return $this->belongsTo(CustomerProfile::class, 'customer_id');
    }

    public function performer()
    {
        return $this->belongsTo(User::class, 'performed_by');
    }
}
