<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class CustomerJourney extends Model
{
    use HasUuids;

    protected $fillable = ['customer_id', 'event', 'description', 'channel', 'metadata'];

    protected $casts = ['metadata' => 'array'];

    public function customer()
    {
        return $this->belongsTo(CustomerProfile::class, 'customer_id');
    }
}
