<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class CustomerLifecycle extends Model
{
    use HasUuids;

    protected $fillable = ['customer_id', 'stage', 'sub_stage', 'entry_date', 'exit_date', 'duration', 'score', 'next_stage', 'actions', 'metadata'];

    protected $casts = ['entry_date' => 'datetime', 'exit_date' => 'datetime', 'actions' => 'array', 'metadata' => 'array'];

    public function customer()
    {
        return $this->belongsTo(CustomerProfile::class, 'customer_id');
    }
}
