<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CustomerProfile extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids;

    protected $fillable = [
        'user_id', 'segment', 'lead_source', 'lead_value',
        'lifetime_value', 'last_contact_date', 'next_follow_up',
        'preferences', 'tags', 'notes', 'is_active',
    ];

    protected $casts = [
        'lead_value' => 'decimal:2',
        'lifetime_value' => 'decimal:2',
        'last_contact_date' => 'datetime',
        'next_follow_up' => 'datetime',
        'preferences' => 'array',
        'tags' => 'array',
        'is_active' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function leads()
    {
        return $this->hasMany(Lead::class, 'customer_id');
    }

    public function opportunities()
    {
        return $this->hasMany(Opportunity::class, 'customer_id');
    }
}
