<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class CustomerServiceMetric extends Model
{
    use HasUuids;

    protected $fillable = ['date', 'period', 'tickets_received', 'tickets_resolved', 'tickets_open', 'avg_resolution_time', 'avg_response_time', 'customer_satisfaction', 'escalations', 'complaints', 'complaints_resolved', 'evaluations', 'avg_rating', 'branch_id', 'metadata'];

    protected $casts = ['date' => 'datetime', 'metadata' => 'array'];

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }
}
