<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class FinancialReport extends Model
{
    use HasUuids;

    protected $fillable = [
        'title', 'type', 'description', 'parameters', 'generated_at',
        'generated_by', 'data', 'file_url', 'status',
    ];

    protected $casts = ['parameters' => 'array', 'data' => 'array', 'generated_at' => 'datetime'];
}
