<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class InsuranceClaim extends Model
{
    use HasUuids;

    protected $fillable = ['claim_number', 'policy_id', 'vehicle_id', 'customer_id', 'type', 'description', 'incident_date', 'incident_location', 'estimated_amount', 'approved_amount', 'status', 'documents', 'notes', 'assigned_to', 'resolved_at', 'created_by'];

    protected $casts = ['incident_date' => 'datetime', 'resolved_at' => 'datetime', 'documents' => 'array'];

    public function policy()
    {
        return $this->belongsTo(InsurancePolicy::class, 'policy_id');
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }
}
