<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class InsuranceCompany extends Model
{
    use HasUuids;

    protected $fillable = ['name', 'code', 'description', 'contact_person', 'phone', 'email', 'address', 'website', 'is_active', 'branch_id', 'created_by'];

    protected $casts = ['is_active' => 'boolean'];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function policies()
    {
        return $this->hasMany(InsurancePolicy::class, 'company_id');
    }
}
