<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class InsurancePaymentRecord extends Model
{
    use HasUuids;

    protected $table = 'insurance_payments';

    protected $fillable = ['policy_id', 'claim_id', 'type', 'amount', 'currency', 'payment_method', 'reference', 'status', 'payment_date', 'due_date', 'notes', 'created_by', 'approved_by'];

    protected $casts = ['payment_date' => 'datetime', 'due_date' => 'datetime'];

    public function policy()
    {
        return $this->belongsTo(InsurancePolicy::class, 'policy_id');
    }

    public function claim()
    {
        return $this->belongsTo(InsuranceClaim::class, 'claim_id');
    }
}
