<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class InsurancePolicy extends Model
{
    use HasUuids;

    protected $fillable = ['policy_number', 'vehicle_id', 'customer_id', 'company_id', 'type', 'start_date', 'end_date', 'premium', 'coverage', 'deductible', 'status', 'documents', 'notes', 'created_by', 'approved_by', 'approved_at'];

    protected $casts = ['start_date' => 'datetime', 'end_date' => 'datetime', 'approved_at' => 'datetime', 'coverage' => 'array', 'documents' => 'array'];

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function company()
    {
        return $this->belongsTo(InsuranceCompany::class, 'company_id');
    }

    public function claims()
    {
        return $this->hasMany(InsuranceClaim::class, 'policy_id');
    }
}
