<?php

namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model
{
    use \Illuminate\Database\Eloquent\Concerns\HasUuids, LogsActivity, SoftDeletes;

    protected $fillable = [
        'invoice_number', 'customer_id', 'branch_id', 'vehicle_id',
        'type', 'status', 'payment_status', 'issue_date', 'due_date',
        'subtotal', 'tax_amount', 'total_amount', 'paid_amount', 'currency',
        'notes', 'terms', 'created_by', 'is_deleted',
    ];

    protected $casts = [
        'issue_date' => 'datetime',
        'due_date' => 'datetime',
        'subtotal' => 'decimal:2',
        'tax_amount' => 'decimal:2',
        'total_amount' => 'decimal:2',
        'paid_amount' => 'decimal:2',
        'is_deleted' => 'boolean',
    ];

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function vehicle()
    {
        return $this->belongsTo(Vehicle::class);
    }

    public function items()
    {
        return $this->hasMany(InvoiceItem::class);
    }

    public function payments()
    {
        return $this->hasMany(Payment::class);
    }
}
