<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;

class InvoiceInstallment extends Model
{
    use HasUuids;

    protected $fillable = [
        'invoice_id', 'sequence', 'amount', 'due_date', 'status',
        'paid_amount', 'paid_at', 'notes', 'payment_id', 'metadata',
    ];

    protected $casts = ['due_date' => 'datetime', 'paid_at' => 'datetime', 'metadata' => 'array'];

    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    public function payment()
    {
        return $this->belongsTo(Payment::class);
    }
}
